﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ReferralContactLogs.aspx.cs" Inherits="ReferralContactLogs" MasterPageFile ="~/Registry.master"  %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href = "styles/StyleSheet.css" />
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    
    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>

     <div class="breadcrumb">
        
              <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text= "My Tasks > Contact Logs > All Contacts"  />
             
    </div>
    
    <br />
    <div class = "excludeSaveWarnings">
    <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Clear"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
     </div>    
     <asp:GridView ID = "GridViewEFRReferralContacts" runat = "server" DataSourceID = "ObjectDataSourceEFRContacts" AutoGenerateColumns = "false"
    AllowPaging="True" PageSize="20" DataKeyNames = "ReferralId" OnRowCommand = "Contacts_RowCommand" AllowSorting = "true" >
       <EmptyDataTemplate>
            No contact logs exist for any referrals
       </EmptyDataTemplate> 
        
        <Columns>
        
            <asp:TemplateField HeaderText = "Referral Number" SortExpression = "ReferralId" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelRefID" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReferralId")), false) %>' ></asp:Label> 
                
                </ItemTemplate> 
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Patient Name" SortExpression = "PatientNameSort">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientName")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Site Number" SortExpression = "StationNumber">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("StationNumber")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Facility" SortExpression = "VAMC">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("VAMC")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Referral Date" SortExpression = "ReferralDate">
                    
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelReferralDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReferralDate", "{0:d}")),false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
                                             
            <asp:TemplateField HeaderText="Status" SortExpression = "ReferralStatus">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelReferralStatus" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReferralStatus")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Last Contact Date" SortExpression = "LastContactDate">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelLastContactDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LastContactDate", "{0:d}")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Number of Contacts" SortExpression = "NumberOfContacts">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelNumberOfContacts" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NumberOfContacts")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
            
        </Columns>
    </asp:GridView>    
    
    <asp:ObjectDataSource ID="ObjectDataSourceEFRContacts" runat="server" 
            SelectMethod="SelectAll" 
            SelectCountMethod="SelectAllCount" 
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True" 
            TypeName="VeteransAffairs.Registries.BusinessManager.ContactLogManager">
            <SelectParameters>
            <asp:ControlParameter Name = "searchValue" ControlID = "TextBoxSearchCriteria" DefaultValue = ""  />  
                <asp:Parameter Name="sort" Type="String" />
                <asp:Parameter Name="startRow" Type="Int32" />
                <asp:Parameter Name="maxRows" Type="Int32" />
            </SelectParameters>        
   </asp:ObjectDataSource>



</asp:Content> 